//
// (c) 2020 wesolutions GmbH
// All rights reserved
//

import QtQuick 2.12

import wesual.Ui 1.0

/*!
\qmltype     UiFocusRect
\inqmlmodule we.captivo.Ui
\since       we.captivo.Ui 1.0
\inherits    QtQuick2::Rectangle
\ingroup     captivo-ui-controls

\brief A focus rectangle to visualize focus state of other controls.

The UiFocusRect control provides a focus rectangle that automatically appears
and disappears according to the focus state of a given \l target.

The following example shows the use of this component:

\qml
import QtQuick 2.4

import wesual.Ui 1.0

Item {
    id : focusable

    activeFocusOnTab : true

    width  : 100
    height : 100

    UiFocusRect {
        anchors.fill : parent
        target : focusable
    }
}
\endqml
*/

Rectangle {
    /*!
    The target for focus state detection.
    */
    property Item target : null

    color : UiColors.getColor(UiColors.FocusColor, .2)
    border {
        width : 1
        color : UiColors.getColor(UiColors.FocusColor, .4)
    }
    opacity : (enabled && target && target.activeFocus) ? 1 : 0
}
